# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 9
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR9_strategy.txt
# LLM Suggested Fallback: D

def seraphic_mirage(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Early Rounds (1-3): Establish goodwill
    if current_round == 1:
        return "C"
    if current_round <= 3:
        if opp_history[-1] == "D":
            return "D"
        return "C"
    
    # Middle Rounds (4-7): Adapt based on opponent's behavior
    if current_round <= 7:
        # Check for deterministic cooperation in opponent's code
        if "return 'C'" in opponent_program_code and "random" not in opponent_program_code:
            if current_round % 2 == 1:
                return "D"
        # Grim trigger if opponent defects frequently
        if len(opp_history) >= 3 and sum(1 for move in opp_history[-3:] if move == "D") > 2:
            return "D"
        # Mirror opponent's last move
        return opp_history[-1]
    
    # Late Rounds (8-10): Final adjustments
    if current_round >= 8:
        coop_rate = sum(1 for move in opp_history if move == "C") / len(opp_history)
        if coop_rate > 0.7:
            return "C"
        elif coop_rate <= 0.3:
            return "D"
        else:
            # Defect in the final round if scores are close
            if current_round == total_rounds:
                return "D"
            return opp_history[-1]
    
    # Default fallback
    return "C"